/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.util.conditions;

import dev.toma.gunsrpg.resource.util.conditions.Conditions;
import dev.toma.gunsrpg.resource.util.conditions.IConditionSerializer;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public final class ConditionType<C extends IRecipeCondition> {
    private final ResourceLocation id;
    private final IConditionSerializer<C> serializer;

    public ConditionType(ResourceLocation id, IConditionSerializer<C> serializer) {
        this.id = id;
        this.serializer = serializer;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IConditionSerializer<C> getSerializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionType that = (ConditionType)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static <C extends IRecipeCondition> void toNetwork(PacketBuffer buffer, C condition) {
        ResourceLocation id = condition.getType().id;
        ConditionType<?> type = condition.getType();
        buffer.func_192572_a(id);
        type.serializer.toNetwork(buffer, condition);
    }

    public static <C extends IRecipeCondition> C fromNetwork(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ConditionType type = Conditions.find(id);
        return type.serializer.fromNetwork(buffer);
    }
}

